/*
 * Decompiled with CFR 0.152.
 */
package me.paypur.tconjei.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import me.paypur.tconjei.jei.MaterialStatsWrapper;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeI18n;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.tconstruct.library.client.materials.MaterialTooltipCache;
import slimeknights.tconstruct.library.materials.MaterialRegistry;
import slimeknights.tconstruct.library.materials.definition.MaterialVariantId;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.tools.stats.BowstringMaterialStats;
import slimeknights.tconstruct.tools.stats.ExtraMaterialStats;
import slimeknights.tconstruct.tools.stats.GripMaterialStats;
import slimeknights.tconstruct.tools.stats.HandleMaterialStats;
import slimeknights.tconstruct.tools.stats.HeadMaterialStats;
import slimeknights.tconstruct.tools.stats.LimbMaterialStats;

public class MaterialStatsCategory
implements IRecipeCategory<MaterialStatsWrapper> {
    final ResourceLocation UID = new ResourceLocation("tconjei", "material_stats");
    final Font font;
    final IDrawable BACKGROUND;
    final IDrawable ICON;
    final int WIDTH = 164;
    final int HEIGHT = 225;
    final int LINE_OFFSET = 20;
    final int LINE_OFFSET_HOVER = 19;
    final int LINE_HEIGHT = 10;
    final int WHITE = 0xFFFFFF;
    int TEXT_COLOR;
    int DURABILITY_COLOR;
    int MINING_COLOR;
    int ATTACK_COLOR;

    public MaterialStatsCategory(IGuiHelper guiHelper) {
        this.font = Minecraft.m_91087_().f_91062_;
        this.WIDTH = 164;
        this.HEIGHT = 225;
        this.LINE_OFFSET = 20;
        this.LINE_OFFSET_HOVER = 19;
        this.LINE_HEIGHT = 10;
        this.WHITE = 0xFFFFFF;
        this.TEXT_COLOR = 0x7E7E7E;
        this.DURABILITY_COLOR = 4639302;
        this.MINING_COLOR = 7839435;
        this.ATTACK_COLOR = 13919075;
        this.BACKGROUND = guiHelper.createBlankDrawable(164, 225);
        this.ICON = guiHelper.createDrawable(new ResourceLocation("tconjei", "textures/gui/icon.png"), 0, 0, 16, 16);
        try {
            ResourceLocation palette = new ResourceLocation("tconjei", "textures/gui/palette.png");
            InputStream stream = Minecraft.m_91087_().m_91098_().m_142591_(palette).m_6679_();
            BufferedImage image = ImageIO.read(stream);
            this.TEXT_COLOR = image.getRGB(0, 0);
            this.DURABILITY_COLOR = image.getRGB(1, 0);
            this.MINING_COLOR = image.getRGB(0, 1);
            this.ATTACK_COLOR = image.getRGB(1, 1);
        }
        catch (IOException e) {
            LogUtils.getLogger().error("Error loading palette", (Throwable)e);
        }
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MaterialStatsWrapper recipe, IFocusGroup focuses) {
        FluidStack fluidStack = recipe.getFluidStack();
        if (!fluidStack.isEmpty()) {
            int BUCKET = 1000;
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 18, 0).addFluidStack(recipe.getFluidStack().getFluid(), 1000L);
            builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addFluidStack(recipe.getFluidStack().getFluid(), 1000L);
            builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack(recipe.getFluidStack().getFluid(), 1000L);
        }
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 0, 0).addItemStacks(recipe.getItemStacks());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipe.getItemStacks());
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(recipe.getItemStacks());
        builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 148, 0).addItemStacks(recipe.getToolParts());
    }

    public void draw(MaterialStatsWrapper statsWrapper, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        String materialName = ForgeI18n.getPattern((String)String.format("material.%s.%s", statsWrapper.getMaterialId().m_135827_(), statsWrapper.getMaterialId().m_135815_()));
        int MATERIAL_COLOR = MaterialTooltipCache.getColor((MaterialVariantId)statsWrapper.getMaterialId()).m_131265_();
        float lineNumber = 0.0f;
        this.font.m_92750_(poseStack, materialName, (float)(164 - this.font.m_92895_(materialName)) / 2.0f, 4.0f, MATERIAL_COLOR);
        Optional headStats = statsWrapper.getStats(HeadMaterialStats.ID);
        Optional extraStats = statsWrapper.getStats(ExtraMaterialStats.ID);
        Optional handleStats = statsWrapper.getStats(HandleMaterialStats.ID);
        Optional limbStats = statsWrapper.getStats(LimbMaterialStats.ID);
        Optional gripStats = statsWrapper.getStats(GripMaterialStats.ID);
        Optional stringStats = statsWrapper.getStats(BowstringMaterialStats.ID);
        if (headStats.isPresent()) {
            String miningLevel = ((HeadMaterialStats)headStats.get()).getTierId().m_135815_();
            this.drawTraits(poseStack, statsWrapper, HeadMaterialStats.ID, lineNumber);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.head")), 0.0f, f * 10.0f + 20.0f, MATERIAL_COLOR);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.durability", String.valueOf(((HeadMaterialStats)headStats.get()).getDurability()), f2, this.DURABILITY_COLOR);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.harvest_tier", ForgeI18n.getPattern((String)("stat.tconstruct.harvest_tier.minecraft." + miningLevel)), f3, this.getMiningLevelColor(miningLevel));
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.mining_speed", String.format("%.2f", Float.valueOf(((HeadMaterialStats)headStats.get()).getMiningSpeed())), f4, this.MINING_COLOR);
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.attack_damage", String.format("%.2f", Float.valueOf(((HeadMaterialStats)headStats.get()).getAttack())), f5, this.ATTACK_COLOR);
            lineNumber += 0.5f;
        } else if (extraStats.isPresent()) {
            this.drawTraits(poseStack, statsWrapper, ExtraMaterialStats.ID, lineNumber);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.extra")), 0.0f, f * 10.0f + 20.0f, MATERIAL_COLOR);
            lineNumber += 0.5f;
        }
        if (handleStats.isPresent()) {
            this.drawTraits(poseStack, statsWrapper, HandleMaterialStats.ID, lineNumber);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.handle")), 0.0f, f * 10.0f + 20.0f, MATERIAL_COLOR);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.durability", String.format("%.2fx", Float.valueOf(((HandleMaterialStats)handleStats.get()).getDurability())), f6, this.getMultiplierColor(Float.valueOf(((HandleMaterialStats)handleStats.get()).getDurability())));
            float f7 = lineNumber;
            lineNumber = f7 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.attack_damage", String.format("%.2fx", Float.valueOf(((HandleMaterialStats)handleStats.get()).getAttackDamage())), f7, this.getMultiplierColor(Float.valueOf(((HandleMaterialStats)handleStats.get()).getAttackDamage())));
            float f8 = lineNumber;
            lineNumber = f8 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.attack_speed", String.format("%.2fx", Float.valueOf(((HandleMaterialStats)handleStats.get()).getAttackSpeed())), f8, this.getMultiplierColor(Float.valueOf(((HandleMaterialStats)handleStats.get()).getAttackSpeed())));
            float f9 = lineNumber;
            lineNumber = f9 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.mining_speed", String.format("%.2fx", Float.valueOf(((HandleMaterialStats)handleStats.get()).getMiningSpeed())), f9, this.getMultiplierColor(Float.valueOf(((HandleMaterialStats)handleStats.get()).getMiningSpeed())));
            lineNumber += 0.5f;
        }
        if (limbStats.isPresent()) {
            this.drawTraits(poseStack, statsWrapper, LimbMaterialStats.ID, lineNumber);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.limb")), 0.0f, f * 10.0f + 20.0f, MATERIAL_COLOR);
            float f10 = lineNumber;
            lineNumber = f10 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.durability", String.valueOf(((LimbMaterialStats)limbStats.get()).getDurability()), f10, this.DURABILITY_COLOR);
            float f11 = lineNumber;
            lineNumber = f11 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.draw_speed", this.signedString(((LimbMaterialStats)limbStats.get()).getDrawSpeed()), f11, this.getDifferenceColor(Float.valueOf(((LimbMaterialStats)limbStats.get()).getDrawSpeed())));
            float f12 = lineNumber;
            lineNumber = f12 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.velocity", this.signedString(((LimbMaterialStats)limbStats.get()).getVelocity()), f12, this.getDifferenceColor(Float.valueOf(((LimbMaterialStats)limbStats.get()).getVelocity())));
            float f13 = lineNumber;
            lineNumber = f13 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.accuracy", this.signedString(((LimbMaterialStats)limbStats.get()).getAccuracy()), f13, this.getDifferenceColor(Float.valueOf(((LimbMaterialStats)limbStats.get()).getAccuracy())));
            lineNumber += 0.5f;
        }
        if (gripStats.isPresent()) {
            this.drawTraits(poseStack, statsWrapper, GripMaterialStats.ID, lineNumber);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.grip")), 0.0f, f * 10.0f + 20.0f, MATERIAL_COLOR);
            float f14 = lineNumber;
            lineNumber = f14 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.durability", String.format("%.2fx", Float.valueOf(((GripMaterialStats)gripStats.get()).getDurability())), f14, this.getMultiplierColor(Float.valueOf(((GripMaterialStats)gripStats.get()).getDurability())));
            float f15 = lineNumber;
            lineNumber = f15 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.accuracy", this.signedString(((GripMaterialStats)gripStats.get()).getAccuracy()), f15, this.getDifferenceColor(Float.valueOf(((GripMaterialStats)gripStats.get()).getAccuracy())));
            float f16 = lineNumber;
            lineNumber = f16 + 1.0f;
            this.drawStatsColor(poseStack, "tool_stat.tconstruct.attack_damage", String.format("%.2f", Float.valueOf(((GripMaterialStats)gripStats.get()).getMeleeAttack())), f16, this.ATTACK_COLOR);
            lineNumber += 0.5f;
        }
        if (stringStats.isPresent()) {
            this.drawTraits(poseStack, statsWrapper, BowstringMaterialStats.ID, lineNumber);
            this.font.m_92750_(poseStack, String.format("[%s]", ForgeI18n.getPattern((String)"stat.tconstruct.bowstring")), 0.0f, lineNumber * 10.0f + 20.0f, MATERIAL_COLOR);
        }
    }

    public List<Component> getTooltipStrings(MaterialStatsWrapper statsWrapper, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Optional<List> component;
        String materialNamespace = statsWrapper.getMaterialId().m_135827_();
        String materialPath = statsWrapper.getMaterialId().m_135815_();
        float lineNumber = 0.0f;
        int matWidth = this.font.m_92895_(materialPath);
        if (this.inBox(mouseX, mouseY, (float)(164 - matWidth) / 2.0f, 3.0f, matWidth, 10.0f)) {
            return List.of(new TranslatableComponent(String.format("material.%s.%s.flavor", materialNamespace, materialPath)).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0xFFFFFF)));
        }
        Optional headStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), HeadMaterialStats.ID);
        Optional extraStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), ExtraMaterialStats.ID);
        Optional handleStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), HandleMaterialStats.ID);
        Optional limbStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), LimbMaterialStats.ID);
        Optional gripStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), GripMaterialStats.ID);
        Optional stringStats = MaterialRegistry.getInstance().getMaterialStats(statsWrapper.getMaterialId(), BowstringMaterialStats.ID);
        if (headStats.isPresent()) {
            List[] listArray = new List[5];
            float f = lineNumber;
            lineNumber = f + 1.0f;
            listArray[0] = this.getTraitTooltips(statsWrapper, HeadMaterialStats.ID, mouseX, mouseY, f);
            float f2 = lineNumber;
            lineNumber = f2 + 1.0f;
            listArray[1] = this.getStatTooltip("tool_stat.tconstruct.durability", mouseX, mouseY, f2);
            float f3 = lineNumber;
            lineNumber = f3 + 1.0f;
            listArray[2] = this.getStatTooltip("tool_stat.tconstruct.harvest_tier", mouseX, mouseY, f3);
            float f4 = lineNumber;
            lineNumber = f4 + 1.0f;
            listArray[3] = this.getStatTooltip("tool_stat.tconstruct.mining_speed", mouseX, mouseY, f4);
            float f5 = lineNumber;
            lineNumber = f5 + 1.0f;
            listArray[4] = this.getStatTooltip("tool_stat.tconstruct.attack_damage", mouseX, mouseY, f5);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        } else if (extraStats.isPresent()) {
            float f = lineNumber;
            lineNumber = f + 1.0f;
            component = this.getTraitTooltips(statsWrapper, ExtraMaterialStats.ID, mouseX, mouseY, f);
            if (!component.isEmpty()) {
                return component;
            }
            lineNumber += 0.5f;
        }
        if (handleStats.isPresent()) {
            List[] listArray = new List[5];
            float f = lineNumber;
            lineNumber = f + 1.0f;
            listArray[0] = this.getTraitTooltips(statsWrapper, HandleMaterialStats.ID, mouseX, mouseY, f);
            float f6 = lineNumber;
            lineNumber = f6 + 1.0f;
            listArray[1] = this.getStatTooltip("tool_stat.tconstruct.durability", mouseX, mouseY, f6);
            float f7 = lineNumber;
            lineNumber = f7 + 1.0f;
            listArray[2] = this.getStatTooltip("tool_stat.tconstruct.attack_damage", mouseX, mouseY, f7);
            float f8 = lineNumber;
            lineNumber = f8 + 1.0f;
            listArray[3] = this.getStatTooltip("tool_stat.tconstruct.attack_speed", mouseX, mouseY, f8);
            float f9 = lineNumber;
            lineNumber = f9 + 1.0f;
            listArray[4] = this.getStatTooltip("tool_stat.tconstruct.mining_speed", mouseX, mouseY, f9);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        }
        if (limbStats.isPresent()) {
            List[] listArray = new List[5];
            float f = lineNumber;
            lineNumber = f + 1.0f;
            listArray[0] = this.getTraitTooltips(statsWrapper, LimbMaterialStats.ID, mouseX, mouseY, f);
            float f10 = lineNumber;
            lineNumber = f10 + 1.0f;
            listArray[1] = this.getStatTooltip("tool_stat.tconstruct.durability", mouseX, mouseY, f10);
            float f11 = lineNumber;
            lineNumber = f11 + 1.0f;
            listArray[2] = this.getStatTooltip("tool_stat.tconstruct.draw_speed", mouseX, mouseY, f11);
            float f12 = lineNumber;
            lineNumber = f12 + 1.0f;
            listArray[3] = this.getStatTooltip("tool_stat.tconstruct.velocity", mouseX, mouseY, f12);
            float f13 = lineNumber;
            lineNumber = f13 + 1.0f;
            listArray[4] = this.getStatTooltip("tool_stat.tconstruct.accuracy", mouseX, mouseY, f13);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        }
        if (gripStats.isPresent()) {
            List[] listArray = new List[4];
            float f = lineNumber;
            lineNumber = f + 1.0f;
            listArray[0] = this.getTraitTooltips(statsWrapper, GripMaterialStats.ID, mouseX, mouseY, f);
            float f14 = lineNumber;
            lineNumber = f14 + 1.0f;
            listArray[1] = this.getStatTooltip("tool_stat.tconstruct.durability", mouseX, mouseY, f14);
            float f15 = lineNumber;
            lineNumber = f15 + 1.0f;
            listArray[2] = this.getStatTooltip("tool_stat.tconstruct.accuracy", mouseX, mouseY, f15);
            float f16 = lineNumber;
            lineNumber = f16 + 1.0f;
            listArray[3] = this.getStatTooltip("tool_stat.tconstruct.attack_damage", mouseX, mouseY, f16);
            component = Stream.of(listArray).filter(list -> !list.isEmpty()).findFirst();
            if (component.isPresent()) {
                return component.get();
            }
            lineNumber += 0.5f;
        }
        if (stringStats.isPresent() && !(component = this.getTraitTooltips(statsWrapper, BowstringMaterialStats.ID, mouseX, mouseY, lineNumber)).isEmpty()) {
            return component;
        }
        return Collections.emptyList();
    }

    private void drawStatsColor(PoseStack poseStack, String type, String stat, float lineNumber, int ACCENT_COLOR) {
        String pattern = ForgeI18n.getPattern((String)type);
        float width = this.font.m_92865_().m_92353_(pattern);
        this.font.m_92883_(poseStack, pattern, 0.0f, lineNumber * 10.0f + 20.0f, this.TEXT_COLOR);
        this.font.m_92883_(poseStack, stat, width, lineNumber * 10.0f + 20.0f, ACCENT_COLOR);
    }

    private int getMiningLevelColor(String miningLevel) {
        return switch (miningLevel) {
            case "wood" -> 9200923;
            case "gold" -> 16558080;
            case "stone" -> 0x979797;
            case "iron" -> 0xDADADA;
            case "diamond" -> 5569788;
            case "netherite" -> 4997443;
            default -> this.TEXT_COLOR;
        };
    }

    private int getMultiplierColor(Float f) {
        if (f.floatValue() < 0.55f) {
            return 0xBD0000;
        }
        if (f.floatValue() < 0.6f) {
            return 12396032;
        }
        if (f.floatValue() < 0.65f) {
            return 12405504;
        }
        if (f.floatValue() < 0.7f) {
            return 12415232;
        }
        if (f.floatValue() < 0.75f) {
            return 12424960;
        }
        if (f.floatValue() < 0.8f) {
            return 0xBDBD00;
        }
        if (f.floatValue() < 0.85f) {
            return 9944320;
        }
        if (f.floatValue() < 0.9f) {
            return 7453952;
        }
        if (f.floatValue() < 0.95f) {
            return 4963584;
        }
        if (f.floatValue() < 1.0f) {
            return 2538752;
        }
        if (f.floatValue() < 1.05f) {
            return 48384;
        }
        if (f.floatValue() < 1.1f) {
            return 48422;
        }
        if (f.floatValue() < 1.15f) {
            return 48459;
        }
        if (f.floatValue() < 1.2f) {
            return 48497;
        }
        if (f.floatValue() < 1.25f) {
            return 48535;
        }
        if (f.floatValue() < 1.3f) {
            return 48573;
        }
        if (f.floatValue() < 1.35f) {
            return 38845;
        }
        if (f.floatValue() < 1.4f) {
            return 29117;
        }
        return 19389;
    }

    private int getDifferenceColor(Float f) {
        return this.getMultiplierColor(Float.valueOf(f.floatValue() + 1.0f));
    }

    private String signedString(float f) {
        return String.format("%s%.2f", f >= 0.0f ? "+" : "", Float.valueOf(f));
    }

    private void drawTraits(PoseStack poseStack, MaterialStatsWrapper statsWrapper, MaterialStatsId statsId, float lineNumber) {
        int MATERIAL_COLOR = MaterialTooltipCache.getColor((MaterialVariantId)statsWrapper.getMaterialId()).m_131265_();
        for (ModifierEntry trait : statsWrapper.getTraits(statsId)) {
            String pattern = ForgeI18n.getPattern((String)String.format("modifier.%s.%s", trait.getId().m_135827_(), trait.getId().m_135815_()));
            float f = lineNumber;
            lineNumber = f + 1.0f;
            this.font.m_92750_(poseStack, pattern, 164.0f - this.font.m_92865_().m_92353_(pattern), f * 10.0f + 20.0f, MATERIAL_COLOR);
        }
    }

    private List<Component> getTraitTooltips(MaterialStatsWrapper statsWrapper, MaterialStatsId statsId, double mouseX, double mouseY, float lineNumber) {
        for (ModifierEntry trait : statsWrapper.getTraits(statsId)) {
            String namespace = trait.getId().m_135827_();
            String path = trait.getId().m_135815_();
            String pattern = ForgeI18n.getPattern((String)String.format("modifier.%s.%s", namespace, path));
            int textWidth = this.font.m_92895_(pattern);
            float f = lineNumber;
            lineNumber = f + 1.0f;
            if (!this.inBox(mouseX, mouseY, 164 - textWidth, f * 10.0f + 19.0f, textWidth, 10.0f)) continue;
            return List.of(new TranslatableComponent(String.format("modifier.%s.%s.flavor", namespace, path)).m_6270_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0xFFFFFF)), new TranslatableComponent(String.format("modifier.%s.%s.description", namespace, path)));
        }
        return Collections.emptyList();
    }

    private List<Component> getStatTooltip(String pattern, double mouseX, double mouseY, float lineNumber) {
        String string = ForgeI18n.getPattern((String)pattern);
        int textWidth = this.font.m_92895_(string);
        if (this.inBox(mouseX, mouseY, 0.0f, lineNumber * 10.0f + 19.0f, textWidth, 10.0f)) {
            return List.of(new TranslatableComponent(pattern + ".description"));
        }
        return Collections.emptyList();
    }

    private boolean inBox(double mX, double mY, float x, float y, float w, float h) {
        return (double)x <= mX && mX <= (double)(x + w) && (double)y <= mY && mY <= (double)(y + h);
    }

    public IDrawable getBackground() {
        return this.BACKGROUND;
    }

    public IDrawable getIcon() {
        return this.ICON;
    }

    public Component getTitle() {
        return new TextComponent("Material Stats");
    }

    public ResourceLocation getUid() {
        return this.UID;
    }

    public Class<? extends MaterialStatsWrapper> getRecipeClass() {
        return MaterialStatsWrapper.class;
    }

    public RecipeType<MaterialStatsWrapper> getRecipeType() {
        return RecipeType.create((String)"tconjei", (String)"material_stats", this.getRecipeClass());
    }
}

